;KBD151.ASM 08FEB04 - JOHN BECKER - EPE PIC TO PS/2 KEYBOARD DEMO

;PIC16F628, 4MHz, WDT OFF, POR ON, XTAL XS

;Config register bits
; CP1 CP0 CP1 CP0 NIL CPD LVP BOR MCL OS2 POR WDT OS1 OS0
;  1   1   1   1   1   1   0   0   1   0   0   0   0   1
;N.B. Logic 1/0 do NOT necessarily mean that the function is On/Off
;respectively - refer to PIC '627/8 data sheet

#DEFINE BANK0 BCF $03,5
#DEFINE BANK1 BSF $03,5

        List P = PIC16F628, R=DEC; 
        __CONFIG   h'3F31'

        include P16F628.inc

        CBLOCK  ; start of automatic EQUates allocation, from $20 onwards

REGA0				;lsb
REGA1
REGA2
REGA3				;msb

DSIGN				;Digit Sign. 0=positive,FF(or non zero)=negative
DIGIT1				;MSD
DIGIT2
DIGIT3
DIGIT4
DIGIT5				;Decimal digits
DIGIT6
DIGIT7
DIGIT8
DIGIT9
DIGIT10				;LSD
MTEMP
MCOUNT
DCOUNT

LOOP
CLKCNT
STORE1
RSLINE
LOOPA

PAR
PAR2
BYTE
BYTE2
STORE
BYTEOUT
        ENDC   ; end of EQUates allocation

                ORG 0                   ; Reset Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 4                   ; Interrupt Vector address
                GOTO 5                  ; go to PIC address location 5
                ORG 5                   ; Start of Program Memory at location 5
                goto START

TABLCD:         addwf PCL,F             ; LCD initialisation table
                retlw B'00110011'       ; initialise lcd - first byte
                retlw B'00110011'       ; 2nd byte (repeat of first)
                retlw B'00110010'       ; set for 4-bit operation
                retlw B'00101100'       ; set for 2 lines
                retlw B'00000110'       ; set entry mode to increment each address
                retlw B'00001100'       ; set display on, cursor off, blink off
                retlw B'00000001'       ; clear display
                retlw B'00000010'       ; return home, cursor & RAM to zero
                                        ; end inititalisation table
                 
MESSAG:         addwf PCL,F
                retlw 'H'
                retlw 'E'
                retlw 'X'
                retlw ' '
                retlw ' '
                retlw 'D'
                retlw 'E'
                retlw 'C'
                retlw ' '

                retlw 'K'
                retlw 'E'
                retlw 'Y'
                retlw ' '
                retlw ' '
                retlw ' '
                retlw ' '

; ***********

START:          clrf PORTA
                clrf PORTB
                movlw $07         ; activate PORTA for PC16F628 as digital
                movwf CMCON

                BANK1
                movlw %00000000   ; PORTB as output
                movwf TRISB
                movlw %00000011   ; RA0, RA1 as input
                movwf TRISA
                movlw %10000110   ; timer 1:128, pull-ups off
                movwf OPTION_REG
                BANK0


SETUP:          call PAUSIT       ; 1st 1/5th sec delay
LCDSET:         clrf LOOP         ; clear LCD set-up loop
                clrf RSLINE       ; clear RS line for instruction send
LCDST2:         movf LOOP,W       ; get table address
                call TABLCD       ; get set-up instruction
                call LCDOUT       ; perform it
                incf LOOP,F       ; inc loop
                btfss LOOP,3      ; has last LCD set-up instruction now been done?
                goto LCDST2       ; no
                call PAUSIT       ; 1/5th sec delay
                 
LCDMSG:         clrf LOOP         ; clear loop
                bsf RSLINE,4      ; set RS for data send
LCDMS2:         movf LOOP,W       ; get table address
                call MESSAG       ; get message letter
                call LCDOUT       ; show it
                incf LOOP,F       ; inc loop
                btfss LOOP,4      ; has last LCD letter been sent?
                goto LCDMS2       ; no, repeat for next


; DATA = RA0   CLK = RA1

; *************

MAIN:           comf PORTA,W
                andlw %00000011
                btfsc STATUS,Z
                goto MAIN

                call RECEIVE      ; get keyboard key pressed

                movf BYTE,W       ; is BYTE > 0
                btfsc STATUS,Z
                goto MAIN         ; no, so try again

                btfss PAR,0       ; yes, is parity bit correct (hi)?
                goto MAIN         ; no, so start again
                btfss PAR2,0      ; yes, so is 2nd parity bit correct (hi)?
                goto MAIN         ; no, so start again

                call SHOWKEY      ; yes, so show data
                movlw ' '
                call LCDOUT

                movf BYTE,W      ; is BYTE = $AA (keyboard OK response on power up)?
                xorlw $AA
                btfss STATUS,Z
                goto MAINA
                call KEYBOARDOK   ; yes
                goto MAIN3        ; no

MAINA:          movf BYTE2,W      ; is BYTE2 = $E1 (pause/break)?
                xorlw $E1
                btfss STATUS,Z
                goto MAINB
                call BREAK        ; yes
                goto MAIN3        ; no

MAINB:          movf BYTE2,W      ; is BYTE2 = $E0?
                xorlw $E0
                btfsc STATUS,Z    ; no
                goto MAIN2        ; yes

                movlw 4           ; BYTE2 = 0 so show BYTE1 data as in Table1
                movwf PCLATH      ; note that both tables are beyond the normal 
                movf BYTE,W       ; 256 table range limit, so PCLATH needs setting for
                call TABLE1       ; the actual table position 
                goto MAIN3

MAIN2:          movlw 6           ; BYTE2 = $E0 so show BYTE1 data as in Table2
		movwf PCLATH
                movf BYTE,W
                call TABLE2

MAIN3:          clrf PCLATH
                call LCDOUT
                movlw ' '
                call LCDOUT
                movlw ' '
                call LCDOUT
                movlw ' '
                call LCDOUT
                movlw ' '
                call LCDOUT
                movlw ' '
                call LCDOUT
                movlw ' '
                call LCDOUT
                movlw ' '
                call LCDOUT
                movlw ' '
                call LCDOUT
                call PAUSIT2
                goto MAIN         ; repeat for next keypress

; ********* RECEIVE KEYBOARD PRESS ******

RECEIVE:
                clrf BYTE
                clrf BYTE2
                movlw 8           ; number of bits
                movwf LOOP
                clrf PAR          ; clear parity record for BYTE
                movlw 1           ; but set parity record for BYTE2
                movwf PAR2

RX1:            btfss PORTA,1     ; wait till clock high (idle clock)
                goto RX1
                btfsc PORTA,0     ; is data line low (start bit low)?
                return            ; no it's high, so a false Start bit, restart

RECDATA:        rrf BYTE,F        ; rotate byte right
                call HIGHLOW      ; wait for clk hi to lo transition
RX2:            btfsc PORTA,0     ; is data low? 
                goto RECSET       ; no, it's high
                bcf BYTE,7        ; yes, data is low so clear bit 7 of BYTE
                goto RECNEXT      ; and ignore parity counter
      
RECSET:         bsf BYTE,7        ; set bit 7 of BYTE
                incf PAR,F        ; inc parity counter
RECNEXT:        decfsz LOOP,F
                goto RECDATA      ; loop until 8 bits have been recd
                call HIGHLOW      ; wait for clk hi to lo transistion

                movf PORTA,W      ; get parity bit
                xorwf PAR,W       ; XOR with parity counter
                andlw 1           ; extract bit 0 of parity
                movwf PAR         ; and store it

                call HIGHLOW      ; get stop bit

                movf BYTE,W       ; is first byte $E0 (1st part of 2-byte set)?
                xorlw $E0
                btfsc STATUS,Z
                call RECEIVE2     ; yes, so get second byte

                movf BYTE,W       ; is first byte $E1 (1st part of 2-byte set)?
                xorlw $E1
                btfss STATUS,Z
                goto RX2A
                call RECEIVE2     ; yes, so get second byte
                goto RX4

RX2A:           movf BYTE,W       ; is first byte $F0 (1st part of 2-byte set)?
                xorlw $F0
                btfsc STATUS,Z
                call RECEIVE2     ; yes, so get second byte

RX4:            return

; ************** get high to low transition ********

HIGHLOW:        btfss PORTA,1     ; loop until CLK high
                goto HIGHLOW
HL2:            btfsc PORTA,1     ; loop until CLK low
                goto HL2
                return

; ********* RECEIVE 2nd KEYBOARD BYTE (if 1st byte = E0, F0, E1) ******

RECEIVE2:       movf BYTE,W       ; copy BYTE & PAR into BYTE2 & PAR2
                movwf BYTE2
                movf PAR,W
                movwf PAR2
                clrf PAR          ; clear parity record

                call HIGHLOW      ; get start bit

                clrf BYTE
                movlw 8           ; number of bits
                movwf LOOP

RECDATA2:       rrf BYTE,F        ; rotate byte right
                call HIGHLOW      ; wait for hi to lo transistion
RX22:           btfsc PORTA,0     ; is data low?
                goto RECSET2      ; no, it's high
                bcf BYTE,7        ; yes; it's high so clear bit 7 of BYTE
                goto RECNEXT2     ; and ignore parity counter
      
RECSET2:        bsf BYTE,7        ; set bit 7 of byte
                incf PAR,F        ; inc parity counter
RECNEXT2:       decfsz LOOP,F
                goto RECDATA2     ; loop until 8 bits have been recd

                call HIGHLOW      ; wait for clk hi to lo transistion
                movf PORTA,W      ; get parity bit
                xorwf PAR,W       ; XOR with parity counter
                andlw 1           ; extract bit 0 of parity
                movwf PAR         ; and store it
                return            ; end of 2nd byte key get routine

; ************  show details on LCD screen ********

SHOWKEY:        call LCD21        ; set to start of line 2
                movf BYTE2,W
                call BIN2HEX      ; convert BYTE2 val to hex
                call SHOWDIG9     ; show it
                movf BYTE,W       
                call BIN2HEX      ; convert BYTE val to hex
                call SHOWDIG9     ; show it

                movlw ' '
                call LCDOUT

                movf BYTE,W       ; convert BYTE val to decimal
                movwf REGA0
                clrf REGA1
                clrf REGA2
                clrf REGA3
                call BIN2DEC
                call SHOWDIG8     ; show it
                return            ; end of show routine
                 
; **********

BREAK:  movlw 'B'
        call LCDOUT
        movlw 'R'
        call LCDOUT
        movlw 'E'
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw 'K'
        call LCDOUT
        return

KEYBOARDOK: movlw 'K'
        call LCDOUT
        movlw 'B'
        call LCDOUT
        movlw 'D'
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw 'O'
        call LCDOUT
        movlw 'K'
        call LCDOUT
        return

; **********

BIN2HEX: movwf STORE
        swapf STORE,W   ;get most significant nibble
        andlw 15
        movwf DIGIT9
        addlw 6
        btfss STATUS,DC
        goto BIN2
        movf DIGIT9,W
        addlw 55        ;set as alpha
        goto BIN3
BIN2:   movf DIGIT9,W
        iorlw 48        ;set as numeral
BIN3:   movwf DIGIT9
        movf STORE,W    ;get least significant nibble
        andlw 15
        movwf DIGIT10
        addlw 6
        btfss STATUS,DC
        goto BIN4
        movf DIGIT10,W
        addlw 55        ;set as alpha
        goto BIN5
BIN4:   movf DIGIT10,W
        iorlw 48        ;set as numeral
BIN5:   movwf DIGIT10
        return

; *********** PART OF PETER HEMSLEY'S 32-BIT MATHS ROUTINES *******

;*** SIGNED BINARY TO DECIMAL ***
;REGA -> DIGITS 1 (MSD) TO 10 (LSD) & DSIGN
;DSIGN = 0 if REGA is positive, FF if negative
;Return carry set if overflow
;Uses FSR register

bin2dec:
        call    clrdig          ; Clear all digits
        clrf    MTEMP           ; Reset sign flag
        call    chksgna         ; Make REGA positive
	skpnc
        call    negatea         ; Negative

        movlw   D'32'           ; Loop counter
	movwf	MCOUNT

b2dloop rlf     REGA0,f         ; Shift msb into carry
	rlf	REGA1,f
	rlf	REGA2,f
	rlf	REGA3,f

	movlw	DIGIT10
        movwf   FSR             ; Pointer to digits
        movlw   D'10'           ; 10 digits to do
	movwf	DCOUNT

adjlp   rlf     INDF,f          ; Shift digit and carry 1 bit left
        movlw   -D'10'
        addwf   INDF,w          ; Check and adjust for decimal overflow
	skpnc
	movwf	INDF

        decf    FSR,f           ; Next digit
	decfsz	DCOUNT,f
	goto	adjlp

        decfsz  MCOUNT,f        ; Next bit
	goto	b2dloop

        btfsc   MTEMP,0         ; Check sign
        comf    DSIGN,f         ; Negative
	clrc

BLANKIT: movlw 48               ; convert to ascii numeral for LCD
        iorwf DIGIT1,F
        iorwf DIGIT2,F
        iorwf DIGIT3,F
        iorwf DIGIT4,F
        iorwf DIGIT5,F
        iorwf DIGIT6,F
        iorwf DIGIT7,F
        iorwf DIGIT8,F
        iorwf DIGIT9,F
        iorwf DIGIT10,F

        movlw 10                ; blank leading zeros
        movwf LOOP
        movlw DIGIT1
        movwf FSR
BLANK:  movf LOOP,W
        movf INDF,W
        andlw 15
        btfss STATUS,Z
        return
        bcf INDF,4
        incf FSR,F
        decfsz LOOP,F
        goto BLANK
        movlw 48
        iorwf DIGIT10,F
        return

; **************

;Negate REGA
;Used by chksgna, multiply, divide, mod, bin2dec, dec2bin

negatea movf    REGA3,w         ; Save sign in w
	andlw	0x80

        comf    REGA0,f         ; 2's complement
	comf	REGA1,f
	comf	REGA2,f
	comf	REGA3,f
	incfsz	REGA0,f
	goto	nega1
	incfsz	REGA1,f
	goto	nega1
	incfsz	REGA2,f
	goto	nega1
	incf	REGA3,f
nega1
        incf    MTEMP,f         ; flip sign flag
        addwf   REGA3,w         ; Return carry set if -2147483648
	return

;Check sign of REGA and convert negative to positive
;Used by multiply, divide, bin2dec

chksgna	rlf	REGA3,w
	skpc
        return                  ; Positive

;Set all digits to 0
;Used by bin2dec

clrdig	clrf	DSIGN
	clrf	DIGIT1
	clrf	DIGIT2
	clrf	DIGIT3
	clrf	DIGIT4
	clrf	DIGIT5
	clrf	DIGIT6
	clrf	DIGIT7
	clrf	DIGIT8
	clrf	DIGIT9
	clrf	DIGIT10
	return

; *********** SHOW DECIMAL DIGITS *********

SHOWDIG1: movf DIGIT1,W
          call LCDOUT
SHOWDIG2: movf DIGIT2,W
          call LCDOUT
SHOWDIG3: movf DIGIT3,W
          call LCDOUT
SHOWDIG4: movf DIGIT4,W
          call LCDOUT
SHOWDIG5: movf DIGIT5,W
          call LCDOUT
SHOWDIG6: movf DIGIT6,W
          call LCDOUT
SHOWDIG7: movf DIGIT7,W
          call LCDOUT
SHOWDIG8: movf DIGIT8,W
          call LCDOUT
SHOWDIG9: movf DIGIT9,W
          call LCDOUT
SHOWDIG10: movf DIGIT10,W
          call LCDOUT
          return

;********** LCD CONTROL SECTION *********

LCD14:  movlw %10001110 ; set screen line start position
        goto LCDLIN

LCD21:  movlw %11000000 ; set screen line start position
        goto LCDLIN

LCDOUT: movwf STORE1    ; temp store value that will be output to LCD
        movlw 60        ; set minimum time between sending full bytes to LCD
        movwf LOOPA
DELAY:  decfsz LOOPA,F
        goto DELAY
        call SENDIT     ; send MSB, then (by default) send LSB

SENDIT: swapf STORE1,F  ; swap byte nibbles
        movf STORE1,W   ; get nibble (MSB)
        andlw 15        ; AND to isolate nibble
        iorwf RSLINE,W  ; OR the RS bit
        movwf PORTB     ; output the byte
        nop
        bsf PORTB,5     ; set E high
        nop
        bcf PORTB,5     ; set E low
        return

LCDLIN: bcf RSLINE,4    ; sets LCD command/line
        call LCDOUT     ; and outputs cmmand code to LCD
        bsf RSLINE,4    ; set RS flag
        return

PAUSIT: movlw 5         ; 1/5th sec wait set
        movwf CLKCNT
        clrf INTCON     ; clear interupt flag
PAUSE:                  ;
        btfss INTCON,2  ; has a timer time-out been detected?
        goto PAUSE      ; no
        bcf INTCON,2    ; yes
        decfsz CLKCNT,F ; dec loop, is it zero?
        goto PAUSE      ; no
        return          ; yes

PAUSIT2: movlw 12       ; approx half sec pause
        movwf CLKCNT
        clrf INTCON     ; clear interupt flag
PAUSE2:                  ;
        btfss INTCON,2  ; has a timer time-out been detected?
        goto PAUSE2     ; no
        bcf INTCON,2    ; yes
        decfsz CLKCNT,F ; dec loop, is it zero?
        goto PAUSE2     ; no
        return          ; yes

; ***************

        org $0400

TABLE1:         addwf PCL,F
                retlw ' '    ; 00
                goto F9      ; 01  F9
                retlw ' '    ; 02
                goto F5      ; 03  F5
                goto F3      ; 04  F3
                goto F1      ; 05  F1
                goto F2      ; 06  F2
                goto F12     ; 07  F12
                retlw ' '    ; 08
                goto F10     ; 09  F10
                goto F8      ; 0A  F8
                goto F6      ; 0B  F6
                goto F4      ; 0C  F4
                goto TAB     ; 0D  tab
                retlw '`'    ; 0E
                retlw ' '    ; 0F

                retlw ' '    ; 10
                goto LEFTALT ; 11  left alt
                goto LSHIFT  ; 12  left shift
                retlw ' '    ; 13
                goto LCTRL   ; 14  left ctrl
                retlw 'q'    ; 15
                retlw '1'    ; 16
                retlw ' '    ; 17
                retlw ' '    ; 18
                retlw ' '    ; 19
                retlw 'z'    ; 1A
                retlw 's'    ; 1B
                retlw 'a'    ; 1C
                retlw 'w'    ; 1D
                retlw '2'    ; 1E
                retlw ' '    ; 1F

                retlw ' '    ; 20
                retlw 'c'    ; 21
                retlw 'x'    ; 22
                retlw 'd'    ; 23
                retlw 'e'    ; 24
                retlw '4'    ; 25
                retlw '3'    ; 26
                goto RWINDOW ; 27
                retlw ' '    ; 28
                goto SPACE   ; 29  space bar
                retlw 'v'    ; 2A
                retlw 'f'    ; 2B
                retlw 't'    ; 2C
                retlw 'r'    ; 2D
                retlw '5'    ; 2E
                retlw ' '    ; 2F

                retlw ' '    ; 30
                retlw 'n'    ; 31
                retlw 'b'    ; 32
                retlw 'h'    ; 33
                retlw 'g'    ; 34
                retlw 'y'    ; 35
                retlw '6'    ; 36
                retlw ' '    ; 37
                retlw ' '    ; 38
                retlw ' '    ; 39
                retlw 'm'    ; 3A
                retlw 'j'    ; 3B
                retlw 'u'    ; 3C
                retlw '7'    ; 3D
                retlw '8'    ; 3E
                retlw ' '    ; 3F

                retlw ' '    ; 40
                retlw 44     ; 41 comma
                retlw 'k'    ; 42
                retlw 'i'    ; 43
                retlw 'o'    ; 44
                retlw '0'    ; 45
                retlw '9'    ; 46
                retlw ' '    ; 47
                retlw ' '    ; 48
                retlw '.'    ; 49
                retlw '/'    ; 4A
                retlw 'l'    ; 4B
                retlw ';'    ; 4C
                retlw 'p'    ; 4D
                retlw '-'    ; 4E
                retlw ' '    ; 4F

                retlw ' '    ; 50
                retlw ' '    ; 51
                retlw '''    ; 52
                retlw ' '    ; 53
                retlw '['    ; 54
                retlw '='    ; 55
                retlw ' '    ; 56
                retlw ' '    ; 57
                goto CAPSLOK ; 58  caps lock
                goto RSHIFT  ; 59  right shift
                goto ENTER   ; 5A  enter
                retlw ']'    ; 5B
                retlw ' '    ; 5C
                retlw '#'    ; 5D
                retlw ' '    ; 5E
                retlw ' '    ; 5F

                retlw ' '    ; 60
                goto BKSLASH ; 61
                retlw ' '    ; 62
                retlw ' '    ; 63
                retlw ' '    ; 64
                retlw ' '    ; 65
                goto BACKSPC ; 66  backspace
                retlw ' '    ; 67
                retlw ' '    ; 68
                retlw '1'    ; 69  keypad 1
                retlw ' '    ; 6A
                retlw '4'    ; 6B  keypad 4
                retlw '7'    ; 6C  keypad 7
                retlw ' '    ; 6D
                retlw ' '    ; 6E
                retlw ' '    ; 6F

                retlw '0'    ; 70  keypad 0
                retlw '.'    ; 71  keypad .
                retlw '2'    ; 72  keypad 2
                retlw '5'    ; 73  keypad 5
                retlw '6'    ; 74  keypad 6
                retlw '8'    ; 75  keypad 8
                goto ESCAPE  ; 76  esc
                goto NUMLOK  ; 77  num lock
                goto F11     ; 78  F11
                retlw '+'    ; 79  keypad +
                retlw '3'    ; 7A  keypad 3
                retlw '-'    ; 7B  keypad -
                retlw '*'    ; 7C  keypad *
                retlw '9'    ; 7D  keypad 9
                goto SCROLOK ; 7E  scroll lock
                retlw ' '    ; 7F

                retlw ' '    ; 80
                retlw ' '    ; 81
                retlw ' '    ; 82
                goto F7      ; 83

TAB:    movlw 'T'
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw 'B'
        call LCDOUT
        return

LEFTALT: movlw 'L'
        call LCDOUT
        movlw '-'
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw 'L'
        call LCDOUT
        movlw 'T'
        call LCDOUT
        return

LSHIFT: movlw 'L'
        call LCDOUT
        movlw '-'
        call LCDOUT
        movlw 'S'
        call LCDOUT
        movlw 'H'
        call LCDOUT
        movlw 'I'
        call LCDOUT
        movlw 'F'
        call LCDOUT
        movlw 'T'
        call LCDOUT
        return

SPACE:  movlw 'S'
        call LCDOUT
        movlw 'P'
        call LCDOUT
        movlw 'C'
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw 'B'
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw 'R'
        call LCDOUT

LCTRL:  movlw 'L'
        call LCDOUT
        movlw '-'
        call LCDOUT
        movlw 'C'
        call LCDOUT
        movlw 'T'
        call LCDOUT
        movlw 'R'
        call LCDOUT
        movlw 'L'
        return

CAPSLOK: movlw 'C'
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw 'P'
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw 'L'
        call LCDOUT
        movlw 'O'
        call LCDOUT
        movlw 'K'
        call LCDOUT
        return

RSHIFT: movlw 'R'
        call LCDOUT
        movlw '-'
        call LCDOUT
        movlw 'S'
        call LCDOUT
        movlw 'H'
        call LCDOUT
        movlw 'I'
        call LCDOUT
        movlw 'F'
        call LCDOUT
        movlw 'T'
        call LCDOUT
        return

ENTER:  movlw 'E'
        call LCDOUT
        movlw 'N'
        call LCDOUT
        movlw 'T'
        call LCDOUT
        movlw 'E'
        call LCDOUT
        movlw 'R'
        call LCDOUT
        return

BACKSPC: movlw 'B'
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw 'C'
        call LCDOUT
        movlw 'K'
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw 'S'
        call LCDOUT
        movlw 'P'
        call LCDOUT
        movlw 'C'
        call LCDOUT
        return

ESCAPE: movlw 'E'
        call LCDOUT
        movlw 'S'
        call LCDOUT
        movlw 'C'
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw 'P'
        call LCDOUT
        movlw 'E'
        return

NUMLOK: movlw 'N'
        call LCDOUT
        movlw 'U'
        call LCDOUT
        movlw 'M'
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw 'L'
        call LCDOUT
        movlw 'O'
        call LCDOUT
        movlw 'C'
        call LCDOUT
        movlw 'K'
        call LCDOUT
        return

F1:     movlw 'F'
        call LCDOUT
        movlw '1'
        call LCDOUT
        return

F2:     movlw 'F'
        call LCDOUT
        movlw '2'
        call LCDOUT
        return

F3:     movlw 'F'
        call LCDOUT
        movlw '3'
        call LCDOUT
        return

F4:     movlw 'F'
        call LCDOUT
        movlw '4'
        call LCDOUT
        return

F5:     movlw 'F'
        call LCDOUT
        movlw '5'
        call LCDOUT
        return

F6:     movlw 'F'
        call LCDOUT
        movlw '6'
        call LCDOUT
        return

F7:     movlw 'F'
        call LCDOUT
        movlw '7'
        call LCDOUT
        return

F8:     movlw 'F'
        call LCDOUT
        movlw '8'
        call LCDOUT
        return

F9:     movlw 'F'
        call LCDOUT
        movlw '9'
        call LCDOUT
        return

F10:    movlw 'F'
        call LCDOUT
        movlw '1'
        call LCDOUT
        movlw '0'
        call LCDOUT
        return

F11:    movlw 'F'
        call LCDOUT
        movlw '1'
        call LCDOUT
        movlw '1'
        call LCDOUT
        return

F12:    movlw 'F'
        call LCDOUT
        movlw '1'
        call LCDOUT
        movlw '2'
        call LCDOUT
        return

SCROLOK: movlw 'S'
        call LCDOUT
        movlw 'C'
        call LCDOUT
        movlw 'R'
        call LCDOUT
        movlw 'L'
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw 'L'
        call LCDOUT
        movlw 'K'
        call LCDOUT
        return

BKSLASH: movlw 'B'
        call LCDOUT
        movlw 'K'
        call LCDOUT
        movlw 'S'
        call LCDOUT
        movlw 'L'
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw 'S'
        call LCDOUT
        movlw 'H'
        call LCDOUT
        return
        
; ************

        org $0600

TABLE2:         addwf PCL,F
                retlw ' '    ; 00
                retlw ' '    ; 01
                retlw ' '    ; 02
                retlw ' '    ; 03
                retlw ' '    ; 04
                retlw ' '    ; 05
                retlw ' '    ; 06
                retlw ' '    ; 07
                retlw ' '    ; 08
                retlw ' '    ; 09
                retlw ' '    ; 0A
                retlw ' '    ; 0B
                retlw ' '    ; 0C
                retlw ' '    ; 0D
                retlw ' '    ; 0E
                retlw ' '    ; 0F

                retlw ' '    ; 10
                goto R-ALT   ; 11
                goto PRNTSCR ; 12
                retlw ' '    ; 13
                goto R-CTRL  ; 14
                retlw ' '    ; 15
                retlw ' '    ; 16
                retlw ' '    ; 17
                retlw ' '    ; 18
                retlw ' '    ; 19
                retlw ' '    ; 1A
                retlw ' '    ; 1B
                retlw ' '    ; 1C
                retlw ' '    ; 1D
                retlw ' '    ; 1E
                goto LWINDOW ; 1F

                retlw ' '    ; 20
                retlw ' '    ; 21
                retlw ' '    ; 22
                retlw ' '    ; 23
                retlw ' '    ; 24
                retlw ' '    ; 25
                retlw ' '    ; 26
                goto RWINDOW ; 27
                retlw ' '    ; 28
                retlw ' '    ; 29
                retlw ' '    ; 2A
                retlw ' '    ; 2B
                retlw ' '    ; 2C
                retlw ' '    ; 2D
                retlw ' '    ; 2E
                goto APPS    ; 2F

                retlw ' '    ; 30
                retlw ' '    ; 31
                retlw ' '    ; 32
                retlw ' '    ; 33
                retlw ' '    ; 34
                retlw ' '    ; 35
                retlw ' '    ; 36
                retlw ' '    ; 37
                retlw ' '    ; 38
                retlw ' '    ; 39
                retlw ' '    ; 3A
                retlw ' '    ; 3B
                retlw ' '    ; 3C
                retlw ' '    ; 3D
                retlw ' '    ; 3E
                retlw ' '    ; 3F

                retlw ' '    ; 40
                retlw ' '    ; 41
                retlw ' '    ; 42
                retlw ' '    ; 43
                retlw ' '    ; 44
                retlw ' '    ; 45
                retlw ' '    ; 46
                retlw ' '    ; 47
                retlw ' '    ; 48
                retlw '.'    ; 49
                retlw '/'    ; 4A
                retlw ' '    ; 4B
                retlw ' '    ; 4C
                retlw ' '    ; 4D
                retlw ' '    ; 4E
                retlw ' '    ; 4F

                retlw ' '    ; 50
                retlw ' '    ; 51
                retlw ' '    ; 52
                retlw ' '    ; 53
                retlw ' '    ; 54
                retlw ' '    ; 55
                retlw ' '    ; 56
                retlw ' '    ; 57
                retlw ' '    ; 58
                retlw ' '    ; 59
                goto KENTER  ; 5A
                retlw ' '    ; 5B
                retlw ' '    ; 5C
                retlw ' '    ; 5D
                retlw ' '    ; 5E
                retlw ' '    ; 5F

                retlw ' '    ; 60
                retlw ' '    ; 61
                retlw ' '    ; 62
                retlw ' '    ; 63
                retlw ' '    ; 64
                retlw ' '    ; 65
                retlw ' '    ; 66
                retlw ' '    ; 67
                retlw ' '    ; 68
                goto END     ; 69
                retlw ' '    ; 6A
                goto L-ARROW ; 6B
                goto HOME    ; 6C
                retlw ' '    ; 6D
                retlw ' '    ; 6E
                retlw ' '    ; 6F

                goto INSERT  ; 70
                goto DELETE  ; 71
                goto DN-ARR  ; 72
                retlw ' '    ; 73
                goto R-ARR   ; 74
                goto UP-ARR  ; 75
                retlw ' '    ; 76
                retlw ' '    ; 77
                retlw ' '    ; 78
                retlw ' '    ; 79
                goto PAGEDN  ; 7A
                retlw ' '    ; 7B
                goto PRNTSCR ; 7C
                goto PAGEUP  ; 7D
                retlw ' '    ; 7E
                retlw ' '    ; 7F

R-ALT:  movlw 'R'
        call LCDOUT
        movlw '-'
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw 'L'
        call LCDOUT
        movlw 'T'
        call LCDOUT
        return

PRNTSCR: movlw 'P'
        call LCDOUT
        movlw 'R'
        call LCDOUT
        movlw 'N'
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw 'S'
        call LCDOUT
        movlw 'C'
        call LCDOUT
        movlw 'R'
        call LCDOUT
        return

R-CTRL: movlw 'R'
        call LCDOUT
        movlw '-'
        call LCDOUT
        movlw 'C'
        call LCDOUT
        movlw 'T'
        call LCDOUT
        movlw 'R'
        call LCDOUT
        movlw 'L'
        call LCDOUT
        return

KENTER: movlw 'E'
        call LCDOUT
        movlw 'N'
        call LCDOUT
        movlw 'T'
        call LCDOUT
        movlw 'E'
        call LCDOUT
        movlw 'R'
        call LCDOUT
        return

END:    movlw 'E'
        call LCDOUT
        movlw 'N'
        call LCDOUT
        movlw 'D'
        call LCDOUT
        return

L-ARROW: movlw 'L'
        call LCDOUT
        movlw '-'
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw 'R'
        call LCDOUT
        movlw 'R'
        call LCDOUT
        return

HOME:   movlw 'H'
        call LCDOUT
        movlw 'O'
        call LCDOUT
        movlw 'M'
        call LCDOUT
        movlw 'E'
        call LCDOUT
        return

INSERT: movlw 'I'
        call LCDOUT
        movlw 'N'
        call LCDOUT
        movlw 'S'
        call LCDOUT
        movlw 'E'
        call LCDOUT
        movlw 'R'
        call LCDOUT
        movlw 'T'
        call LCDOUT
        return

DELETE: movlw 'D'
        call LCDOUT
        movlw 'E'
        call LCDOUT
        movlw 'L'
        call LCDOUT
        movlw 'E'
        call LCDOUT
        movlw 'T'
        call LCDOUT
        movlw 'E'
        call LCDOUT
        return

DN-ARR: movlw 'D'
        call LCDOUT
        movlw 'N'
        call LCDOUT
        movlw '-'
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw 'R'
        call LCDOUT
        movlw 'R'
        call LCDOUT
        return

R-ARR:  movlw 'R'
        call LCDOUT
        movlw '-'
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw 'R'
        call LCDOUT
        movlw 'R'
        call LCDOUT
        return

UP-ARR: movlw 'U'
        call LCDOUT
        movlw 'P'
        call LCDOUT
        movlw '-'
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw 'R'
        call LCDOUT
        movlw 'R'
        call LCDOUT
        return

PAGEDN: movlw 'P'
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw 'G'
        call LCDOUT
        movlw 'E'
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw 'D'
        call LCDOUT
        movlw 'N'
        call LCDOUT
        return

PAGEUP: movlw 'P'
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw 'G'
        call LCDOUT
        movlw 'E'
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw 'U'
        call LCDOUT
        movlw 'P'
        call LCDOUT
        return

LWINDOW: movlw 'L'
        call LCDOUT
        movlw '-'
        call LCDOUT
        movlw 'W'
        call LCDOUT
        movlw 'I'
        call LCDOUT
        movlw 'N'
        call LCDOUT
        return

RWINDOW: movlw 'R'
        call LCDOUT
        movlw '-'
        call LCDOUT
        movlw 'W'
        call LCDOUT
        movlw 'I'
        call LCDOUT
        movlw 'N'
        call LCDOUT
        return

APPS:   movlw 'A'
        call LCDOUT
        movlw 'P'
        call LCDOUT
        movlw 'P'
        call LCDOUT
        movlw 'S'
        call LCDOUT
        movlw ' '
        call LCDOUT
        return

;*******************

        end                     ; final line
